//////////////////////////////////////////////////////////////////////
////                                                              ////
////  Advantech Co., Ltd	FPGA Design                           ////
////                                                              ////
//////////////////////////////////////////////////////////////////////
////  Project	: TI Shannon EVM FPGA                             ////
////  File name	: shevm_fpga_pad.v		                          ////
////  Description                                                 ////
////      		: Shannon EVM FPGA Core MODULE                    ////
////  Created Date                                                ////
////			: 2010/12/09									  ////
//////////////////////////////////////////////////////////////////////
////                                                              ////
//// Copyright (C) 2010 Advantech Co., Ltd                        ////
////                                                              ////
//////////////////////////////////////////////////////////////////////

	`include "params.v"


module shevm_fpga_pad(
	//GLOBAL
	MAIN_48MHZ_CLK_R_p,VCC3_AUX_PGOOD_p,
	
	main_48mhz_clk_r_i,vcc3_aux_pgood_i,	
	
	//DSP SPI
	DSP_SSPCS1_p,DSP_SSPCK_p,DSP_SSPMISO_p,DSP_SSPMOSI_p,
	
	dsp_sspcs1_i,dsp_sspck_i,dsp_sspmiso_o,dsp_sspmosi_i,
	
	//POWER ON
	VCC5_PGOOD_p,VCC2P5_PGOOD_p,VCC0P75_PGOOD_p,VCC1P5_PGOOD_p,SYS_PGOOD_p,VCC1P8_PGOOD_p,
	VCC1P5_EN_p,VCC1P8_EN1_p,VCC0P75_EN_p,VCC2P5_EN_p,VCC_5V_EN_p,
	
	vcc5_pgood_i,vcc2p5_pgood_i,vcc0p75_pgood_i,vcc1p5_pgood_i,sys_pgood_o,vcc1p8_pgood_i,
	vcc1p5_en_o,vcc1p8_en1_o,vcc0p75_en_o,vcc2p5_en_o,vcc_5v_en_o,
	
	//GPIO
	BM_GPIO_p,DSP_GPIO_p,USER_DEFINE_p,
	
	bm_gpio_i,dsp_gpio_i,dsp_gpio_o,dsp_gpio_en,user_define_i,
	
	gpio3_alt_miso,         
    gpio3_alt_miso_outen, 
	
	//DEBUG
	DEBUG_LED_p,
	
	debug_led_o,
	
	//DSP CONTROL
	DSP_PACLKSEL_p,DSP_LRESETNMIENZ_p,DSP_CORESEL_p,DSP_NMIZ_p,DSP_LRESETZ_p,DSP_HOUT_p,DSP_BOOTCOMPLETE_p,
	DSP_SYSCLKOUT_p,DSP_PORZ_p,DSP_RESETFULLZ_p,DSP_RESETZ_p,DSP_RESETSTAT_np,

	dsp_paclksel_o,dsp_lresetnmienz_o,dsp_coresel_o,dsp_nmiz_o,dsp_lresetz_o,dsp_hout_i,dsp_bootcomplete_i,
	dsp_sysclkout_i,dsp_porz_o,dsp_resetfullz_o,dsp_resetz_o,dsp_resetstat_ni,
	
	//TI MMC
	MMC_DETECT_np,MMC_RESETSTAT_np,MMC_POR_IN_AMC_np,MMC_WR_AMC_np,MMC_BOOTCOMPLETE_p,
	
	mmc_detect_ni,mmc_resetstat_no,mmc_por_in_amc_ni,mmc_wr_amc_ni,mmc_bootcomplete_o,
	
	//PHY
	PHY_INT_np,PHY_RST_np,
	
	phy_int_ni,phy_rst_no,
	
	//RESET
	FULL_RESET_p,WARM_RESET_p,COLD_RESET_p,FPGA_RST_N_p,
	
	full_reset_i,warm_reset_i,cold_reset_i,fpga_rst_n_i,
	
	//OTHER
	DSP_VCL_1_p,DSP_VD_1_p,NAND_WP_p,XDS560_IL_p,NOR_WP_np,EEPROM_WP_p,PCA9306_EN_p,
		
	dsp_vcl_1_i,dsp_vd_1_o,nand_wp_o,xds560_il_o,nor_wp_no,eeprom_wp_o,pca9306_en_o,
	
	fpga_update_en,  update_miso, update_mosi, update_csb, update_clk,  
	
	TRGRSTZ_p, trgrstz_i,
	PCIESSEN_p, pciessen_i,
	DSP_TIMI0_p, dsp_timi0_o,
	
	//CLOCK
	CLOCK2_SSPCS1_p,CLOCK2_SSPCK_p,CLOCK2_SSPSI_p,CLOCK2_SSPSO_p,REFCLK2_PD_np,CLOCK2_PLL_LOCK_p,
	CLOCK3_SSPCS1_p,CLOCK3_SSPCK_p,CLOCK3_SSPSI_p,CLOCK3_SSPSO_p,REFCLK3_PD_np,CLOCK3_PLL_LOCK_p,
	
	clock2_sspcs1_o,clock2_sspck_o,clock2_sspsi_o,clock2_sspso_i,refclk2_pd_no,clock2_pll_lock_i,
	clock3_sspcs1_o,clock3_sspck_o,clock3_sspsi_o,clock3_sspso_i,refclk3_pd_no,clock3_pll_lock_i,
	
	//UCD9222	
	UCD9222_PG1_p,UCD9222_PG2_p,UCD9222_ENA1_p,UCD9222_ENA2_p,PGUCD9222_p,UCD9222_RST_np,

	ucd9222_pg1_i,ucd9222_pg2_i,ucd9222_ena1_o,ucd9222_ena2_o,pgucd9222_i,ucd9222_rst_no,
	
	//PMBUS
	PMBUS_CLK_p,PMBUS_DAT_p, PMBUS_ALT_p, PMBUS_CTL_p,
	
	pmbus_clk_o,pmbus_dat_i,pmbus_dat_o,pmbus_dat_en, pmbus_alt_i, pmbus_ctl_i,//input for test only
	
	//DIFFERENT to SINGLE CLOCK
	TDM_CLKA_N_p, TDM_CLKA_P_p, TDM_CLKB_N_p, TDM_CLKB_P_p,  
    TDM_CLKC_N_p, TDM_CLKC_P_p, TDM_CLKD_N_p, TDM_CLKD_P_p,
	
	TP13, TP14, // for test/debug TSIP
	   
    DSP_TSIP0_CLKA0_p, DSP_TSIP0_CLKB0_p, DSP_TSIP1_CLKA1_p, DSP_TSIP1_CLKB1_p,
    DSP_TSIP0_FSA0_p, DSP_TSIP0_FSB0_p, DSP_TSIP1_FSA1_p, DSP_TSIP1_FSB1_p,
	 
	 
	    //PCIE CLOCK MUX CONTROL  	
   FPGA_ICS557_OE_p, FPGA_ICS557_PD_np, FPGA_ICS557_SEL_p,
	 fpga_ics557_oe_o, fpga_ics557_pd_no, fpga_ics557_sel_o,

	   //VID OE CONTROL	 
   VID_OE_np,
	 vid_oe_no  	 
	 
);

/*******************************/  
/**** 	GLOBAL	   *****/
/*******************************/

input MAIN_48MHZ_CLK_R_p;
output main_48mhz_clk_r_i;

assign main_48mhz_clk_r_i = MAIN_48MHZ_CLK_R_p;

input VCC3_AUX_PGOOD_p;
output vcc3_aux_pgood_i;

assign vcc3_aux_pgood_i = VCC3_AUX_PGOOD_p;

/*******************************/  
/**** 	POWER ON	   *****/
/*******************************/	
	
input VCC5_PGOOD_p;
output vcc5_pgood_i;

assign vcc5_pgood_i = VCC5_PGOOD_p;

input VCC2P5_PGOOD_p;
output vcc2p5_pgood_i;

assign vcc2p5_pgood_i = VCC2P5_PGOOD_p;

input VCC0P75_PGOOD_p;
output vcc0p75_pgood_i;

assign vcc0p75_pgood_i = VCC0P75_PGOOD_p;

input VCC1P5_PGOOD_p;
output vcc1p5_pgood_i;

assign vcc1p5_pgood_i = VCC1P5_PGOOD_p;

output SYS_PGOOD_p;
input sys_pgood_o;

assign SYS_PGOOD_p = sys_pgood_o;

input VCC1P8_PGOOD_p;
output vcc1p8_pgood_i;

assign vcc1p8_pgood_i = VCC1P8_PGOOD_p;

output VCC1P5_EN_p;
input vcc1p5_en_o;

assign VCC1P5_EN_p = vcc1p5_en_o;

output VCC1P8_EN1_p;
input vcc1p8_en1_o;

assign VCC1P8_EN1_p = vcc1p8_en1_o;

output VCC0P75_EN_p;
input vcc0p75_en_o;

assign VCC0P75_EN_p = vcc0p75_en_o;

output VCC2P5_EN_p;
input vcc2p5_en_o;

assign VCC2P5_EN_p = vcc2p5_en_o;

output VCC_5V_EN_p;
//input VCC_5V_EN_p;//troy 20110407
input vcc_5v_en_o;

assign VCC_5V_EN_p = vcc_5v_en_o;

/*******************************/  
/**** 	MMC SPI	   *****/
/*******************************/	
	
input DSP_SSPCS1_p;
output dsp_sspcs1_i;

assign dsp_sspcs1_i = (~VCC0P75_PGOOD_p) ? 1'b1 : DSP_SSPCS1_p;

input DSP_SSPCK_p;
output dsp_sspck_i;

assign dsp_sspck_i = (~VCC0P75_PGOOD_p) ? 1'b0 : DSP_SSPCK_p;

output DSP_SSPMISO_p;
input dsp_sspmiso_o;

assign DSP_SSPMISO_p = (~VCC0P75_PGOOD_p) ? 1'b0 : (dsp_sspcs1_i)? 1'bz : dsp_sspmiso_o;   //20110112

input DSP_SSPMOSI_p;
output dsp_sspmosi_i;

assign dsp_sspmosi_i = (~VCC0P75_PGOOD_p) ? 1'b0 : DSP_SSPMOSI_p;

/*******************************/  
/**** 	GPIO	   *****/
/*******************************/

input	[15:0]	BM_GPIO_p;
output	[15:0]	bm_gpio_i;

assign bm_gpio_i = BM_GPIO_p;

inout	[15:0]	DSP_GPIO_p;
output	[15:0]	dsp_gpio_i;
wire    [15:0]  dsp_gpio_i;
input	[15:0]	dsp_gpio_o;
input		dsp_gpio_en;

//////////////////// FPGA update
input  fpga_update_en;
input  update_miso;
output update_mosi;
output update_csb;
output update_clk;  
wire   update_mosi;
wire   update_csb;
wire   update_clk;  
////////////////////////////////////

input  gpio3_alt_miso;         
input  gpio3_alt_miso_outen;

wire  mux_dsp_gpio3; 
wire  mux_dsp_gpio3_en;

assign mux_dsp_gpo3 = (gpio3_alt_miso_outen)? gpio3_alt_miso : dsp_gpio_o[3];
assign mux_dsp_gpo3_en = (gpio3_alt_miso_outen | dsp_gpio_en)? 1'b1 : 1'b0;

wire   mux_dsp_gpo15;
wire   mux_dsp_gpo15_en;

assign mux_dsp_gpo15 = (fpga_update_en)? update_miso : dsp_gpio_o[15];
assign mux_dsp_gpo15_en = (fpga_update_en)? 1'b1 : dsp_gpio_en;
assign update_mosi = (fpga_update_en)? dsp_gpio_i[14] : 1'b0 ;  //20110128
assign update_csb = (fpga_update_en)? dsp_gpio_i[13] : 1'b1 ;  //20110128
assign update_clk = (fpga_update_en)? dsp_gpio_i[12] : 1'b1 ;  //20110128

assign dsp_gpio_i = DSP_GPIO_p;
//assign DSP_GPIO_p = (~VCC0P75_PGOOD_p) ? 16'b0 : (dsp_gpio_en ? dsp_gpio_o : 16'hz);
// DSP_GPIO[15] = update_miso   (fpga output to dsp)
// DSP_GPIO[14] = update_mosi
// DSP_GPIO[13] = update_csb
// DSP_GPIO[12] = update_clk
//assign DSP_GPIO_p[14:0] = (~VCC0P75_PGOOD_p) ? 16'b0 : (dsp_gpio_en ? dsp_gpio_o[14:0] : 15'hz);
assign DSP_GPIO_p[2:0] = (~VCC0P75_PGOOD_p) ? 3'h0 : (dsp_gpio_en ? dsp_gpio_o[2:0] : 3'hz);
assign DSP_GPIO_p[3] =  (~VCC0P75_PGOOD_p) ? 1'b0 : (mux_dsp_gpo3_en ? mux_dsp_gpo3 : 1'bz);
assign DSP_GPIO_p[14:4] = (~VCC0P75_PGOOD_p) ? 11'h0 : (dsp_gpio_en ? dsp_gpio_o[14:4] : 11'hz);
assign DSP_GPIO_p[15] = (~VCC0P75_PGOOD_p) ? 1'b0 : (mux_dsp_gpo15_en ? mux_dsp_gpo15 : 1'bz);

	
input		USER_DEFINE_p;  //20101205
output		user_define_i;  //20101205

//assign user_define_i = (~VCC0P75_PGOOD_p) ? 1'b0 : USER_DEFINE_p;
assign user_define_i = USER_DEFINE_p;

/*******************************/  
/**** 	DEBUG	   *****/
/*******************************/

output	[3:0]	DEBUG_LED_p;
input	[3:0]	debug_led_o;

//assign DEBUG_LED_p = (~VCC0P75_PGOOD_p) ? 4'b0 : debug_led_o;
assign DEBUG_LED_p = (fpga_update_en)? {~dsp_gpio_i[13:12], debug_led_o[1:0]} : debug_led_o[3:0];   //20110211 for debug LED Power-On status

/*******************************/  
/**** 	DSP CONTROL	   *****/
/*******************************/

output DSP_PACLKSEL_p;
input dsp_paclksel_o;

assign DSP_PACLKSEL_p = (~VCC0P75_PGOOD_p) ? 1'b0 : dsp_paclksel_o;

output DSP_LRESETNMIENZ_p;
input dsp_lresetnmienz_o;

assign DSP_LRESETNMIENZ_p = (~VCC0P75_PGOOD_p) ? 1'b0 : dsp_lresetnmienz_o;

output	[3:0]	DSP_CORESEL_p;
input	[3:0]	dsp_coresel_o;

assign DSP_CORESEL_p = (~VCC0P75_PGOOD_p) ? 4'b0 : dsp_coresel_o;

output DSP_NMIZ_p;
input dsp_nmiz_o;

assign DSP_NMIZ_p = (~VCC0P75_PGOOD_p) ? 1'b0 : dsp_nmiz_o;

output DSP_LRESETZ_p;
input dsp_lresetz_o;

assign DSP_LRESETZ_p = (~VCC0P75_PGOOD_p) ? 1'b0 : dsp_lresetz_o;

input DSP_HOUT_p;
output dsp_hout_i;

assign dsp_hout_i = (~VCC0P75_PGOOD_p) ? 1'b0 : DSP_HOUT_p;

input DSP_BOOTCOMPLETE_p;
output dsp_bootcomplete_i;

assign dsp_bootcomplete_i = (~VCC0P75_PGOOD_p) ? 1'b0 : DSP_BOOTCOMPLETE_p;

input DSP_SYSCLKOUT_p;
output dsp_sysclkout_i;

assign dsp_sysclkout_i = (~VCC0P75_PGOOD_p) ? 1'b0 : DSP_SYSCLKOUT_p;

output DSP_PORZ_p;
input dsp_porz_o;

assign DSP_PORZ_p = (~VCC0P75_PGOOD_p) ? 1'b0 : dsp_porz_o;

output DSP_RESETFULLZ_p;
input dsp_resetfullz_o;

assign DSP_RESETFULLZ_p = (~VCC0P75_PGOOD_p) ? 1'b0 : dsp_resetfullz_o;

output DSP_RESETZ_p;
input dsp_resetz_o;

assign DSP_RESETZ_p = (~VCC0P75_PGOOD_p) ? 1'b0 : dsp_resetz_o;

input DSP_RESETSTAT_np;
output dsp_resetstat_ni;
reg dsp_resetstat_ni;


always @(DSP_RESETSTAT_np or VCC0P75_PGOOD_p)	
begin
     if (VCC0P75_PGOOD_p == 1'b0)
  	     dsp_resetstat_ni <= 1'b0;
	 else
 	     dsp_resetstat_ni <= DSP_RESETSTAT_np;
end

//assign dsp_resetstat_ni = (~VCC0P75_PGOOD_p) ? 1'b0 : DSP_RESETSTAT_np;

/*******************************/  
/**** 	TI MMC	   *****/
/*******************************/

input MMC_DETECT_np;
output mmc_detect_ni;

assign mmc_detect_ni = MMC_DETECT_np;

output MMC_RESETSTAT_np;
input mmc_resetstat_no;

assign MMC_RESETSTAT_np = mmc_resetstat_no;

input MMC_POR_IN_AMC_np;
output mmc_por_in_amc_ni;

assign mmc_por_in_amc_ni = MMC_POR_IN_AMC_np;

input MMC_WR_AMC_np;
output mmc_wr_amc_ni;

assign mmc_wr_amc_ni = MMC_WR_AMC_np;

output MMC_BOOTCOMPLETE_p;
input mmc_bootcomplete_o;

assign MMC_BOOTCOMPLETE_p = mmc_bootcomplete_o;

/*******************************/  
/**** 	PHY	   *****/
/*******************************/

input PHY_INT_np;
output phy_int_ni;

assign phy_int_ni = (~VCC0P75_PGOOD_p) ? 1'b1 : PHY_INT_np;

output PHY_RST_np;
input phy_rst_no;

assign PHY_RST_np = (~VCC0P75_PGOOD_p) ? 1'b0 : phy_rst_no;

/*******************************/  
/**** 	RESET	   *****/
/*******************************/

input FULL_RESET_p;
output full_reset_i;

assign full_reset_i = FULL_RESET_p;

input WARM_RESET_p;
output warm_reset_i;

assign warm_reset_i = WARM_RESET_p;

input COLD_RESET_p;
output cold_reset_i;

assign cold_reset_i = COLD_RESET_p;

input FPGA_RST_N_p;
output fpga_rst_n_i;

assign fpga_rst_n_i = FPGA_RST_N_p;

/*******************************/  
/**** 	OTHER	   *****/
/*******************************/

//output DSP_VCL_1_p;
input DSP_VCL_1_p;   //20101205
output dsp_vcl_1_i;  //20101205

//assign DSP_VCL_1_p = (~VCC0P75_PGOOD_p) ? 1'b0 : dsp_vcl_1_o;
assign dsp_vcl_1_i = DSP_VCL_1_p;  //20101205

//output DSP_VD_1_p;
inout DSP_VD_1_p;  //20101205
input dsp_vd_1_o;

//assign DSP_VD_1_p = (~VCC0P75_PGOOD_p) ? 1'b0 : dsp_vd_1_o;
assign DSP_VD_1_p = 1'bZ; //20101205

output NAND_WP_p;
input nand_wp_o;

assign NAND_WP_p = (~VCC0P75_PGOOD_p) ? 1'b0 : nand_wp_o;

output XDS560_IL_p;
input xds560_il_o;

assign XDS560_IL_p = (~VCC0P75_PGOOD_p) ? 1'b0 : xds560_il_o;

output NOR_WP_np;
input nor_wp_no;

assign NOR_WP_np = (~VCC0P75_PGOOD_p) ? 1'b0 : nor_wp_no;

output EEPROM_WP_p;
input eeprom_wp_o;

assign EEPROM_WP_p = (~VCC0P75_PGOOD_p) ? 1'b0 : eeprom_wp_o;

output PCA9306_EN_p;
input pca9306_en_o;

assign PCA9306_EN_p = (~VCC0P75_PGOOD_p) ? 1'b0 : pca9306_en_o;

input  TRGRSTZ_p;
output trgrstz_i;
wire trgrstz_i;

assign trgrstz_i = (~VCC0P75_PGOOD_p) ? 1'b1 : TRGRSTZ_p; 

input PCIESSEN_p;
output pciessen_i;
wire pciessen_i;

assign pciessen_i = PCIESSEN_p; 

input dsp_timi0_o;
output DSP_TIMI0_p;
wire DSP_TIMI0_p;

assign DSP_TIMI0_p = (~VCC0P75_PGOOD_p) ? 1'b0 : dsp_timi0_o;

/*******************************/  
/**** 	CLOCK	   *****/
/*******************************/

output CLOCK2_SSPCS1_p;
input clock2_sspcs1_o;

assign CLOCK2_SSPCS1_p = clock2_sspcs1_o;

output CLOCK2_SSPCK_p;
input clock2_sspck_o;

assign CLOCK2_SSPCK_p = clock2_sspck_o;

output CLOCK2_SSPSI_p;
input clock2_sspsi_o;

assign CLOCK2_SSPSI_p = clock2_sspsi_o;

input CLOCK2_SSPSO_p;
output clock2_sspso_i;

assign clock2_sspso_i = CLOCK2_SSPSO_p;

output REFCLK2_PD_np;
input refclk2_pd_no;

assign REFCLK2_PD_np = refclk2_pd_no;

input CLOCK2_PLL_LOCK_p;
output clock2_pll_lock_i;

assign clock2_pll_lock_i = CLOCK2_PLL_LOCK_p;

output CLOCK3_SSPCS1_p;
input clock3_sspcs1_o;

assign CLOCK3_SSPCS1_p = clock3_sspcs1_o;

output CLOCK3_SSPCK_p;
input clock3_sspck_o;

assign CLOCK3_SSPCK_p = clock3_sspck_o;

output CLOCK3_SSPSI_p;
input clock3_sspsi_o;

assign CLOCK3_SSPSI_p = clock3_sspsi_o;

input CLOCK3_SSPSO_p;
output clock3_sspso_i;

assign clock3_sspso_i = CLOCK3_SSPSO_p;

output REFCLK3_PD_np;
input refclk3_pd_no;

assign REFCLK3_PD_np = refclk3_pd_no;

input CLOCK3_PLL_LOCK_p;
output clock3_pll_lock_i;

assign clock3_pll_lock_i = CLOCK3_PLL_LOCK_p;

/*******************************/  
/**** 	UCD9222	   *****/
/*******************************/

input UCD9222_PG1_p;
output ucd9222_pg1_i;

assign ucd9222_pg1_i = UCD9222_PG1_p;

input UCD9222_PG2_p;
output ucd9222_pg2_i;

assign ucd9222_pg2_i = UCD9222_PG2_p;

output UCD9222_ENA1_p;
input ucd9222_ena1_o;

assign UCD9222_ENA1_p = ucd9222_ena1_o;

output UCD9222_ENA2_p;
input ucd9222_ena2_o;

assign UCD9222_ENA2_p = ucd9222_ena2_o;

input PGUCD9222_p;
output pgucd9222_i;

assign pgucd9222_i = PGUCD9222_p;
	
output UCD9222_RST_np;
input ucd9222_rst_no;

assign UCD9222_RST_np = ucd9222_rst_no;

/*******************************/  
/**** 	PMBUS	   *****/
/*******************************/

//output PMBUS_CLK_p;  //20101229 for test
input PMBUS_CLK_p;
input pmbus_clk_o;

wire pmclk_tmp1;   //20101229 for test
assign pmclk_tmp1 = PMBUS_CLK_p; //20101229 for test
//assign PMBUS_CLK_p = pmbus_clk_o;

//inout PMBUS_DAT_p;  //20101229 for test
input PMBUS_DAT_p;
output pmbus_dat_i;
input pmbus_dat_o;
input pmbus_dat_en;

assign pmbus_dat_i = PMBUS_DAT_p;
//assign PMBUS_DAT_p = pmbus_dat_en ? pmbus_dat_o : 1'bz;

input PMBUS_ALT_p;
output pmbus_alt_i;
assign pmbus_alt_i = PMBUS_ALT_p;

input PMBUS_CTL_p;
output pmbus_ctl_i;
assign pmbus_ctl_i = PMBUS_CTL_p;

/*******************************/  
/**** 	PMBUS	   *****/
/*******************************/

/*********************************/  
/**** 	Differential 2 Single*****/
/*********************************/
input TDM_CLKA_N_p;
input TDM_CLKA_P_p;
input TDM_CLKB_N_p;
input TDM_CLKB_P_p;
input TDM_CLKC_N_p;
input TDM_CLKC_P_p;
input TDM_CLKD_N_p;
input TDM_CLKD_P_p;
output DSP_TSIP0_CLKA0_p;
output DSP_TSIP0_CLKB0_p;
output DSP_TSIP1_CLKA1_p;
output DSP_TSIP1_CLKB1_p;
output DSP_TSIP0_FSA0_p;
output DSP_TSIP0_FSB0_p;
output DSP_TSIP1_FSA1_p;
output DSP_TSIP1_FSB1_p;

output TP13, TP14;
wire TP13, TP14;
assign	TP13 = DSP_TSIP0_CLKA0_p ;
assign	TP14 = DSP_TSIP0_FSA0_p ;

   wire S_TDM_CLKA;
   IBUFDS #(.IBUF_DELAY_VALUE("0") ,.IFD_DELAY_VALUE("AUTO") ,.IOSTANDARD("DEFAULT"))
         u1(.O(S_TDM_CLKA)         ,.I(TDM_CLKA_P_p)         ,.IB(TDM_CLKA_N_p));
/*
   wire S_TDM_CLKB;
   IBUFDS #(.IBUF_DELAY_VALUE("0") ,.IFD_DELAY_VALUE("AUTO") ,.IOSTANDARD("DEFAULT"))
         u2(.O(S_TDM_CLKB)         ,.I(TDM_CLKB_P_p)         ,.IB(TDM_CLKB_N_p));
*/
   wire S_TDM_CLKC;
   IBUFDS #(.IBUF_DELAY_VALUE("0") ,.IFD_DELAY_VALUE("AUTO") ,.IOSTANDARD("DEFAULT"))
         u3(.O(S_TDM_CLKC)         ,.I(TDM_CLKC_P_p)         ,.IB(TDM_CLKC_N_p));
/*
   wire S_TDM_CLKD;
   IBUFDS #(.IBUF_DELAY_VALUE("0") ,.IFD_DELAY_VALUE("AUTO") ,.IOSTANDARD("DEFAULT"))
         u4(.O(S_TDM_CLKD)         ,.I(TDM_CLKD_P_p)         ,.IB(TDM_CLKD_N_p));
*/  
/*       
  diff_2_sig_clk DIFF( .FPGA_48MHz(main_48mhz_clk_r_i)       ,.FPGA_rst(vcc3_aux_pgood_i) 
                      ,.S_TDM_CLKA(S_TDM_CLKA)               ,.S_TDM_CLKB(S_TDM_CLKB)        
                      ,.S_TDM_CLKC(S_TDM_CLKC)               ,.S_TDM_CLKD(S_TDM_CLKD)
                      ,.DSP_TSIP0_CLKA0_o(DSP_TSIP0_CLKA0_t) ,.DSP_TSIP0_CLKB0_o(DSP_TSIP0_CLKB0_t)
                      ,.DSP_TSIP1_CLKA1_o(DSP_TSIP1_CLKA1_t) ,.DSP_TSIP1_CLKB1_o(DSP_TSIP1_CLKB1_t)
                      ,.DSP_TSIP0_FSA0_o(DSP_TSIP0_FSA0_t)   ,.DSP_TSIP0_FSB0_o(DSP_TSIP0_FSB0_t)  
                      ,.DSP_TSIP1_FSA1_o(DSP_TSIP1_FSA1_t)   ,.DSP_TSIP1_FSB1_o(DSP_TSIP1_FSB1_t));
*/
  diff_2_sig_clk DIFF( .FPGA_48MHz(main_48mhz_clk_r_i)       ,.FPGA_rst(vcc3_aux_pgood_i) 
                      ,.S_TDM_CLKA(S_TDM_CLKA)               ,.S_TDM_CLKB(1'b0)        
                      ,.S_TDM_CLKC(S_TDM_CLKC)               ,.S_TDM_CLKD(1'b0)
                      ,.DSP_TSIP0_CLKA0_o(DSP_TSIP0_CLKA0_t) ,.DSP_TSIP0_CLKB0_o(DSP_TSIP0_CLKB0_t)
                      ,.DSP_TSIP1_CLKA1_o(DSP_TSIP1_CLKA1_t) ,.DSP_TSIP1_CLKB1_o(DSP_TSIP1_CLKB1_t)
                      ,.DSP_TSIP0_FSA0_o(DSP_TSIP0_FSA0_t)   ,.DSP_TSIP0_FSB0_o(DSP_TSIP0_FSB0_t)  
                      ,.DSP_TSIP1_FSA1_o(DSP_TSIP1_FSA1_t)   ,.DSP_TSIP1_FSB1_o(DSP_TSIP1_FSB1_t));



assign DSP_TSIP0_CLKA0_p  = (~VCC0P75_PGOOD_p) ? 1'b0 : DSP_TSIP0_CLKA0_t; 
assign DSP_TSIP0_CLKB0_p  = (~VCC0P75_PGOOD_p) ? 1'b0 : DSP_TSIP0_CLKB0_t; 
assign DSP_TSIP1_CLKA1_p  = (~VCC0P75_PGOOD_p) ? 1'b0 : DSP_TSIP1_CLKA1_t; 
assign DSP_TSIP1_CLKB1_p  = (~VCC0P75_PGOOD_p) ? 1'b0 : DSP_TSIP1_CLKB1_t; 
assign DSP_TSIP0_FSA0_p   = (~VCC0P75_PGOOD_p) ? 1'b0 : DSP_TSIP0_FSA0_t ; 
assign DSP_TSIP0_FSB0_p   = (~VCC0P75_PGOOD_p) ? 1'b0 : DSP_TSIP0_FSB0_t ; 
assign DSP_TSIP1_FSA1_p   = (~VCC0P75_PGOOD_p) ? 1'b0 : DSP_TSIP1_FSA1_t ; 
assign DSP_TSIP1_FSB1_p   = (~VCC0P75_PGOOD_p) ? 1'b0 : DSP_TSIP1_FSB1_t ; 

/*******************************/                      
/*    PCIE CLOCK MUX CONTROL   */
/*******************************/
output FPGA_ICS557_OE_p;
output FPGA_ICS557_PD_np;
output FPGA_ICS557_SEL_p;
input  fpga_ics557_oe_o;
input  fpga_ics557_pd_no;
input  fpga_ics557_sel_o;

assign FPGA_ICS557_OE_p  = fpga_ics557_oe_o;   //0:dsiable 1: enable 
assign FPGA_ICS557_PD_np = fpga_ics557_pd_no;  //low active
assign FPGA_ICS557_SEL_p = fpga_ics557_sel_o;  //0:clk gen 1:HCSI


/*******************************/                      
/*        VID OE CONTROL       */
/*******************************/
output VID_OE_np;
input  vid_oe_no;  	 
assign VID_OE_np = vid_oe_no;
                      
endmodule 